/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.monitor;

import com.ibm.hwmca.base.monitor.MonitorConstants;
import com.ibm.hwmca.base.monitor.MonitorTask;
import com.ibm.hwmca.base.monitor.config.MonitorActionTypeConfig;
import com.ibm.hwmca.base.monitor.config.MonitorConfigParser;
import com.ibm.hwmca.base.monitor.config.MonitorGroupConfig;
import com.ibm.hwmca.base.monitor.config.MonitorsConfig;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.HMCTimer;
import com.ibm.hwmca.fw.util.HMCTimerTask;
import com.ibm.hwmca.fw.util.TimerParms;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class MonitorMgr
implements Runnable,
MonitorConstants {
    private static final String TRACE_MASKD = "XMONMGRD";
    private static final String TRACE_MASKF = "XMONMGRF";
    private static final String TRACE_MASKT = "XMONMGRT";
    private static final int MAX_UNEXPECTED_ERRORS_TO_LOG = 5;
    private int unexpectedErrors = 0;
    private HashMap actionTypeSuccesses = null;
    private String xMLFileName = null;

    MonitorMgr(String xMLFileName) throws IllegalArgumentException {
        if (xMLFileName == null || xMLFileName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.xMLFileName = xMLFileName;
        Trace.trace(TRACE_MASKT, "<->MonitorMgr(" + xMLFileName + ")");
    }

    public static void main(String[] args) {
        MonitorMgr mgr = null;
        StringBuffer argsLine = null;
        try {
            argsLine = new StringBuffer();
            for (int i = 0; i < args.length; ++i) {
                argsLine.append(' ');
                argsLine.append(args[i]);
            }
            Trace.trace(TRACE_MASKT, "main() called with the following parameters :" + argsLine.toString());
            if (args.length != 1) {
                System.exit(-1);
            }
            mgr = new MonitorMgr(args[0]);
            new Thread((Runnable)mgr, "CCFW Manager Monitor").start();
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block8: {
            MonitorsConfig config = null;
            ArrayList monitorGroups = null;
            MonitorGroupConfig monitorGroup = null;
            long everyXMinutes = 0L;
            MonitorTask task = null;
            HMCTimer hMCTimer = null;
            TimerParms timerParms = null;
            Trace.trace(TRACE_MASKT, "-> run()");
            try {
                config = new MonitorConfigParser(this.xMLFileName).parseXML();
                MonitorMgr monitorMgr = this;
                synchronized (monitorMgr) {
                    this.actionTypeSuccesses = new HashMap();
                    Iterator i = config.getActionTypes().values().iterator();
                    while (i.hasNext()) {
                        this.actionTypeSuccesses.put(((MonitorActionTypeConfig)i.next()).getName(), new Integer(0));
                    }
                }
                monitorGroups = config.getMonitorGroups();
                if (monitorGroups != null && monitorGroups.size() > 0) {
                    hMCTimer = HMCTimer.getHMCTimer();
                    Iterator i = monitorGroups.iterator();
                    while (i.hasNext()) {
                        monitorGroup = (MonitorGroupConfig)i.next();
                        everyXMinutes = monitorGroup.getEveryXMinutes();
                        task = new MonitorTask(monitorGroup, config.getActionTypes(), this);
                        timerParms = new TimerParms(0L, everyXMinutes * 60000L, true, null);
                        hMCTimer.schedule((HMCTimerTask)task, timerParms);
                    }
                }
            }
            catch (Throwable t) {
                Trace.trace(TRACE_MASKF, "Unexpected throwable caught while running monitor manager : " + t);
                Trace.trace(TRACE_MASKF, t);
                if (this.unexpectedErrors >= 5) break block8;
                new FrameworkLog(MonitorConstants.LOG_INFO, 3, t).log();
                ++this.unexpectedErrors;
            }
        }
        Trace.trace(TRACE_MASKT, "<- start()");
    }

    synchronized int getSuccessesSoFar(String actionTypeName) {
        Integer successes = null;
        int result = 0;
        successes = (Integer)this.actionTypeSuccesses.get(actionTypeName);
        if (successes != null) {
            result = successes;
        }
        return result;
    }

    synchronized void incSuccessesSoFar(String actionTypeName) {
        Integer successes = null;
        successes = (Integer)this.actionTypeSuccesses.get(actionTypeName);
        if (successes != null) {
            this.actionTypeSuccesses.put(actionTypeName, new Integer(successes + 1));
        }
    }
}

